//=============================================================================
//              |
// Headerfile   |  common.h
//              |
// Description  |  Declaration of data types using by ROBOPro (fischertechnik)
//              |
//-----------------------------------------------------------------------------
// Disclaimer - Exclusion of Liability
//
// This software is distributed in the hope that it will be useful,but WITHOUT 
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. It can be used an modified by anyone
// free of any license obligations or authoring rights.
//=============================================================================

#ifndef __COMMON_H__
// Protect against multiple file inclusion
#define __COMMON_H__


//  declaration of data types using by RoboPro (fischertechnik)

typedef signed char         CHAR8;
typedef unsigned char       UCHAR8;

typedef unsigned char       BOOL8;        //  Boolean variable (should be TRUE or FALSE)
typedef unsigned short      BOOL16;
typedef unsigned int        BOOL32;

typedef signed char         INT8;
typedef short               INT16;
typedef signed int          INT32;

typedef unsigned char       UINT8;
typedef unsigned short      UINT16;
typedef unsigned int        UINT32;


#endif
